import 'package:flutter/material.dart';
import 'package:razinsoft_rider/core/extensions/extensions.dart';

import 'app_marker.dart';

class AppMarkerPickup extends StatelessWidget {
  final String? address;
  const AppMarkerPickup({
    super.key,
    this.address,
  });

  @override
  Widget build(BuildContext context) => AppMarker(
      title: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text(
            'Pick-up',
            style: context.labelMedium,
          ),
          Text(
            address ?? 'Drag to adjust',
            maxLines: 1,
            overflow: TextOverflow.ellipsis,
            style: context.bodyMedium?.copyWith(
              color: context.theme.colorScheme.onSurfaceVariant,
            ),
          ),
        ],
      )

    );
}
